/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import oracle.ias.cache.group.GroupCommunication;
import oracle.ias.cache.group.Packet;

public class HttpPacket {
    Packet m_packet;
    File m_attachedFile;
    InputStream m_input_stream;
    byte[] m_packet_buf;
    long m_packet_size = 0L;
    long m_file_size = 0L;
    long m_stream_size = 0L;
    public static final String s_crlf = new String("\r\n");
    public static final String s_separator = new String(": ");
    public static final int s_separator_length = 2;
    public static final String s_request_line = new String("POST /cache HTTP/1.1");
    public static final String s_version_header = new String("Version");
    public static final String s_content_length_header = new String("Content-Length");
    public static final String s_packet_length_header = new String("Packet-Length");
    public static final String s_file_length_header = new String("File-Length");

    public HttpPacket(Packet packet) throws IOException {
        this.m_packet = packet;
        String string = packet.getAttachedFileName();
        this.m_attachedFile = string != null ? new File(string) : null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.m_packet);
        this.m_packet_buf = byteArrayOutputStream.toByteArray();
        this.m_packet_size = this.m_packet_buf.length;
        if (this.m_attachedFile != null) {
            this.m_file_size = this.m_attachedFile.length();
        }
        this.m_input_stream = packet.getInputStream();
        this.m_stream_size = packet.getStreamSize();
    }

    public byte[] getPacketBuffer() {
        return this.m_packet_buf;
    }

    public Packet getPacket() {
        return this.m_packet;
    }

    public boolean hasAttachedFile() {
        return this.m_attachedFile != null;
    }

    public File getAttachedFile() {
        return this.m_attachedFile;
    }

    public boolean hasInputStream() {
        return this.m_input_stream != null;
    }

    public InputStream getInputStream() {
        return this.m_input_stream;
    }

    public long getStreamSize() {
        return this.m_stream_size;
    }

    public byte[] getHeaders() {
        StringBuffer stringBuffer = new StringBuffer(s_request_line);
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_version_header);
        stringBuffer.append(s_separator);
        stringBuffer.append(GroupCommunication.getVersion());
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_content_length_header);
        stringBuffer.append(s_separator);
        if (this.m_file_size != 0L) {
            stringBuffer.append(this.m_packet_size + this.m_file_size);
        } else if (this.m_stream_size != 0L) {
            stringBuffer.append(this.m_packet_size + this.m_stream_size);
        } else {
            stringBuffer.append(this.m_packet_size);
        }
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_packet_length_header);
        stringBuffer.append(s_separator);
        stringBuffer.append(this.m_packet_size);
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_file_length_header);
        stringBuffer.append(s_separator);
        if (this.m_file_size != 0L) {
            stringBuffer.append(this.m_file_size);
        } else if (this.m_stream_size != 0L) {
            stringBuffer.append(this.m_stream_size);
        } else {
            stringBuffer.append(0);
        }
        stringBuffer.append(s_crlf);
        stringBuffer.append(s_crlf);
        return stringBuffer.toString().getBytes();
    }
}

